﻿//////////////////////////////////////////////
// NodeWrapper.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class Environment ;
	class UserType ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

// nkScripts
#include <NilkinsScripts/Environments/Functions/Function.h>

/// Class ------------------------------------

namespace nkAstraeus::nkGraphicsWrap
{
	class DLL_ASTRAEUS_EXPORT NodeWrapper final
	{
		public :

			// Environment update
			static void updateEnvironment (nkScripts::Environment* env) ;
			static void inherit (nkScripts::UserType* childType) ;

			// Callbacks
			// Tree
			static nkScripts::OutputValue setParentNode (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getParentNode (const nkScripts::DataStack& stack) ;
			// Position
			static nkScripts::OutputValue translateAbsolute (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue translateRelative (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setPositionAbsolute (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setPositionRelative (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getPositionAbsolute (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getPositionRelative (const nkScripts::DataStack& stack) ;
			// Rotation
			static nkScripts::OutputValue rotateAbsolute (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue rotateRelative (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setOrientationAbsolute (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setOrientationRelative (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getOrientationAbsolute (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getOrientationRelative (const nkScripts::DataStack& stack) ;
			// Scale
			static nkScripts::OutputValue applyScale (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setScaleAbsolute (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setScaleRelative (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getScaleAbsolute (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getScaleRelative (const nkScripts::DataStack& stack) ;
			// Transform
			static nkScripts::OutputValue setRelativeTransform (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setAbsoluteTransform (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getRelativeTransform (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getAbsoluteTransform (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue updateTransformations (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue dispatchDirtyTransform (const nkScripts::DataStack& stack) ;
			// Entities
			static nkScripts::OutputValue addEntityToTrack (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue stopEntityTracking (const nkScripts::DataStack& stack) ;
			// Axes
			static nkScripts::OutputValue getAbsoluteUp (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getAbsoluteFront (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getAbsoluteRight (const nkScripts::DataStack& stack) ;
	} ;
}